package parser;

/**
 * Grammar non-terminal -- V ::= id T1
 */
public class V implements S {
    /**
     * Id object.
     */
    private IdToken _id;

    /**
     * T1 object.
     */
    private T1 _t1;

    /**
     * Constructor for the V grammar non-terminal.
     *
     * @param id id object
     * @param t1 T1 object
     */
    public V(IdToken id, T1 t1) {
        _id = id;
        _t1 = t1;
    }

    /**
     * Return a string representation.
     *
     * @return string representation
     */
    public String toString() {
        return _id.toString() + _t1.toString();
    }
}

